<?php 
//==============================
// GENERAL HELPERS 
//==============================

class Helper{

    public function Test(){
        return "Hola Mundo Help";
    }

    //create slug string
    public function Slug($cadena, $separador = '-'){
      //sin espacios al inicio o al final
      $cadena = (isset($cadena)) ? trim($cadena) : "";
      //utf8
      //$cadena = utf8_decode($cadena);
      //limpiamos caracteres los latinos
      $cadena = str_replace(array('À','Á','Â','Ã','Ä','Å','à','á','â','ã','ä','å','Aacute','aacute'),"a",$cadena);
      $cadena = str_replace(array('È','É','Ê','Ë','è','é','ê','ë','Eacute','eacute'),"e",$cadena);
      $cadena = str_replace(array('Ì','Í','Î','Ï','ì','í','î','ï','Iacute','iacute'),"i",$cadena);
      $cadena = str_replace(array('Ò','Ó','Ô','Õ','Ö','Ø','ò','ó','ô','õ','ö','ø','Oacute','oacute'),"o",$cadena);
      $cadena = str_replace(array('Ù','Ú','Û','Ü','ù','ú','û','ü','Uacute','uacute'),"u",$cadena);
      //La ñ
      $cadena = str_replace(array('Ñ','ñ','Ntilde','ntilde'),"n",$cadena);
      //Caracteres extraños
      $cadena = str_replace(array('Ç','ç'),"c",$cadena);
      $cadena = str_replace('ÿ',"y",$cadena);
      //Cambiamos la coma
      $cadena = str_replace(',',$separador,$cadena);
      //Pasamos a minúscula la cadena
      $cadena = strtolower($cadena);
      //Limpiamos saltos de líneas y tab
      $cadena = preg_replace("|[ \t\n\r]+|", " ", $cadena);
      //Limpiamos todos los caracteres inválidos
      $cadena = preg_replace("|[^ A-Za-z0-9_]|", "", $cadena);
      //Limpieza de espacios vacíos de los valores inválidos al final de la cadena
      $cadena = trim($cadena);
      //Reemplazamos los espacios vacios por el separador
      $cadena = str_replace(' ',$separador,$cadena);
      //Reemplazamos los separadores repetidos
      $cadena = str_replace($separador.$separador.$separador.$separador.$separador,$separador, $cadena);
      $cadena = str_replace($separador.$separador.$separador.$separador,$separador, $cadena);
      $cadena = str_replace($separador.$separador.$separador,$separador, $cadena);
      $cadena = str_replace($separador.$separador,$separador, $cadena);
      return $cadena;
    }

    // get Hours minutes second from datetime HH:ii:ss  
    public function GetClock($clockget,$type){
        $infotime = explode(":",$clockget);
        switch ($type) {
        case 'H':
            return $infotime[0];
            break;
        case 'i':
            return $infotime[1];
            break;
        case 's':
            return $infotime[2];
            break;
        default:
            return "";
        }
    }

    public function GetDate($dateget,$type,$format="yyyymmdd",$separator="-"){

           $leng = (isset($_COOKIE["language"]))? $_COOKIE["language"] : "es_ES";
           $infodate = explode($separator,$dateget);
           $yearDate;$monthDate;$dayDate;

           if($format=="yyyymmdd"){
            $yearDate   =   $infodate[0]; 
            $monthDate  =   $infodate[1]; 
            $dayDate    =   $infodate[2];
          }else if($format=="ddmmyyyy"){
            $yearDate   =   $infodate[2];
            $monthDate  =   $infodate[1];
            $dayDate    =   $infodate[0];
          }



          $mapate = array(
            "M" => array(
              "es_ES" => array(
                "01"=> "Ene",
                "02"=> "Feb",
                "03"=> "Mar",
                "04"=> "Abr",
                "05"=> "May",
                "06"=> "Jun",
                "07"=> "Jul",
                "08"=> "Ago",
                "09"=> "Sep",
                "10"=> "Oct",
                "11"=> "Nov",
                "12"=> "Dic",
              ),
              "en_US" => array(
                "01"=> "Jan",
                "02"=> "Feb",
                "03"=> "Mar",
                "04"=> "Apr",
                "05"=> "May",
                "06"=> "Jun",
                "07"=> "Jul",
                "08"=> "Aug",
                "09"=> "Sep",
                "10"=> "Oct",
                "11"=> "Nov",
                "12"=> "Dec",
              ),
              "pt_BR" => array(
                "01"=> "Jan",
                "02"=> "Fev",
                "03"=> "Mar",
                "04"=> "Apr",
                "05"=> "Mai",
                "06"=> "Jun",
                "07"=> "Jul",
                "08"=> "Ago",
                "09"=> "Set",
                "10"=> "Out",
                "11"=> "Nov",
                "12"=> "Dez",
              ),
            ),
            "m" => array(
              "es_ES" => array(
                "01"=> "Enero",
                "02"=> "Febrero",
                "03"=> "Marzo",
                "04"=> "Abril",
                "05"=> "Mayo",
                "06"=> "Junio",
                "07"=> "Julio",
                "08"=> "Agosto",
                "09"=> "Septiembre",
                "10"=> "Octubre",
                "11"=> "Noviembre",
                "12"=> "Diciciembre",
              ),
              "en_US" => array(
                "01"=> "January",
                "02"=> "February",
                "03"=> "March",
                "04"=> "April",
                "05"=> "May",
                "06"=> "June",
                "07"=> "July",
                "08"=> "August",
                "09"=> "September",
                "10"=> "October",
                "11"=> "November",
                "12"=> "December",
              ),
              "pt_BR" => array(
                "01"=> "Janeiro",
                "02"=> "Fevereiro",
                "03"=> "Março",
                "04"=> "Abril",
                "05"=> "Maio",
                "06"=> "Junho",
                "07"=> "Julho",
                "08"=> "Agosto",
                "09"=> "Setembro",
                "10"=> "Outubro",
                "11"=> "Novembro",
                "12"=> "Dezembro",
              ),
            ),
        );

        switch ($type) {
            case 'M':
              return $mapate[$type][$leng][$monthDate];
              break;
            case 'm':
              return $mapate[$type][$leng][$monthDate];
              break;
            case 'd':
              return $dayDate;
              break;
            case 'Y':
              return $yearDate;
              break;   
            default:
              return "";
          }



    }

    public function ToneHexadec($color,$tone,$v=0){
        $color = str_replace("#","",$color);

        if($tone=="dark"){
          $r = hexdec(substr($color,0,2))-$v;
          $g = hexdec(substr($color,2,2))-$v;
          $b = hexdec(substr($color,4,2))-$v;
          if($r>255){ $r =255; }
          if($g>255){ $g =255; }
          if($b>255){ $b =255; } 
          return "#".dechex($r).dechex($g).dechex($b);
        }else if($tone=="light"){
          $r = hexdec(substr($color,0,2))+$v;
          $g = hexdec(substr($color,2,2))+$v;
          $b = hexdec(substr($color,4,2))+$v;
          if($r<0){ $r =0; }
          if($g<0){ $g =0; }
          if($b<0){ $b =0; }
          return "#".dechex($r).dechex($g).dechex($b);
        }else{
          return "#".$color;
        }
        
    }

    public function GetColor($color,$return="rgb",$tono="none",$v=0){

            
            if($return=="rgb"){
                $color = str_replace("#","",$color);
                switch ($tono){
                  case "dark":
                    $r = hexdec(substr($color,0,2))-$v;
                    $g = hexdec(substr($color,2,2))-$v;
                    $b = hexdec(substr($color,4,2))-$v;
                    if($r>255){ $r =255; }
                    if($g>255){ $g =255; }
                    if($b>255){ $b =255; }
                    break;
                  case "light":
                    $r = hexdec(substr($color,0,2))+$v;
                    $g = hexdec(substr($color,2,2))+$v;
                    $b = hexdec(substr($color,4,2))+$v;
                    if($r<0){ $r =0; }
                    if($g<0){ $g =0; }
                    if($b<0){ $b =0; }
                    break;
                  default:
                    $r = hexdec(substr($color,0,2));
                    $g = hexdec(substr($color,2,2));
                    $b = hexdec(substr($color,4,2));
                }
                return $r.",".$g.",".$b;
            }

            if($return=="#"){
              $color = explode(",",$color);
              switch ($tono){
                case "dark":
                  $r = dechex($color[0]-$v);
                  $g = dechex($color[1]-$v);
                  $b = dechex($color[2]-$v);
                  if(($color[0]+$v)>255){ $r = "00"; }
                  if(($color[1]+$v)>255){ $g = "00"; }
                  if(($color[2]+$v)>255){ $b = "00"; }
                  break;
                case "light":
                  $r = dechex($color[0]+$v);
                  $g = dechex($color[1]+$v);
                  $b = dechex($color[2]+$v);
                  if(($color[0]-$v)<0){ $r = "FF"; }
                  if(($color[1]-$v)<0){ $g = "FF"; }
                  if(($color[2]-$v)<0){ $b = "FF"; }
                  break;
                default:
                  $r = dechex($color[0]);
                  $g = dechex($color[1]);
                  $b = dechex($color[2]);
              }
              
              return "#".$r.$g.$b;
            }



    }

    public function cambiar_fecha($fecha, $formato){ 
      $H='00'; $i='00'; $s='00'; $F=''; $M=''; $num_mes=0;
      $Meses = ['',_('Enero'),_('Febrero'),_('Marzo'),_('Abril'),_('Mayo'), _('Junio'),_('Julio'),
      _('Agosto'),_('Septiembre'),_('Octubre'),_('Noviembre'),_('Diciembre')];
      $meses = ['',_('Ene'),_('Feb'),_('Mar'),_('Abr'),_('May'),_('Jun'),_('Jul') ,_('Ago'),_('Sep'),_('Oct'),_('Nov'),_('Dic')];
      //Fecha recibida en ingles con hora
      if(preg_match( "/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})/", $fecha, $mifecha)){
      $num_mes=$mifecha[2]; settype($num_mes, "integer");
      $D=$mifecha[3]; $m=$mifecha[2]; $F=$Meses[$num_mes]; $M=$meses[$num_mes]; $Y=$mifecha[1]; 
      $H=$mifecha[4]; $i=$mifecha[5]; $s=$mifecha[6];
      }
      //Fecha recibida en español con hora
      elseif(preg_match( "/([0-9]{1,2})-([0-9]{1,2})-([0-9]{4}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})/", $fecha, $mifecha)){
      $num_mes=$mifecha[2]; settype($num_mes, 'integer');
      $D=$mifecha[1]; $m=$mifecha[2]; $F=$Meses[$num_mes]; $M=$meses[$num_mes]; $Y=$mifecha[3]; 
      $H=$mifecha[4]; $i=$mifecha[5]; $s=$mifecha[6];
      }
      //Fecha recibida en ingles sin hora
      elseif(preg_match( "/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})/", $fecha, $mifecha)){
      $num_mes=$mifecha[2]; settype($num_mes, 'integer');
      $D=$mifecha[3]; $m=$mifecha[2]; $F=$Meses[$num_mes]; $M=$meses[$num_mes]; $Y=$mifecha[1];
      }
      //Fecha recibida en español sin hora
      elseif(preg_match( "/([0-9]{1,2})-([0-9]{1,2})-([0-9]{4})/", $fecha, $mifecha)){
      $num_mes=$mifecha[2]; settype($num_mes, 'integer');
      $D=$mifecha[1]; $m=$mifecha[2]; $F=$Meses[$num_mes]; $M=$meses[$num_mes]; $Y=$mifecha[3];
      }
      
      // Variable [y] ultimas dos cifras del año
      $y = substr($Y, 2);
      
      if(@$_COOKIE['language'] == "en_US"){
        if($formato=='D de F Y') {
          $formato = 'F D de Y';
        }
        if($formato=='H:i') {
          if($H>12){
            $H = $H - 12;
            $i.= " pm";
          }else{
            $i.= " am";
          }
        }
        if (!in_array(($D % 100),array(11,12,13))){
            switch ($D % 10) {
              // Handle 1st, 2nd, 3rd
              case 1:
                $sufijo='tt';
                break;
              case 2:
                $sufijo='nd';
                break;
              case 3: 
                $sufijo='rd';
                break;
              default:
              $sufijo='th';
              break;
              }
          }
        $D.= $sufijo;
        $formato = preg_replace( '/D/', $D, $formato ); // [D] días	
        $formato = str_replace('de', '', $formato);
      }else{
        $formato = preg_replace( '/D/', $D, $formato ); // [D] días	
      }
  
      $formato = preg_replace( '/m/', $m, $formato ); // [m] mes con numeros
      $formato = preg_replace( '/Y/', $Y, $formato ); // [Y] año de 4 cifras
      $formato = preg_replace( '/y/', $y, $formato ); // [y] año de 2 cifras
      $formato = preg_replace( '/H/', $H, $formato ); // [H] hora de 0 a 23
      $formato = preg_replace( '/H/', $H, $formato ); // [H] hora de 0 a 23
      $formato = preg_replace( '/i/', $i, $formato ); // [i] minutos de 0 a 59
      $formato = preg_replace( '/s/', $s, $formato ); // [s] segundos de 0 a 59
      // Tienen que ir al final porque llevan texto para no ser reemplazado
      $formato = preg_replace( '/M/', $M, $formato ); // [M] mes con 3 letras
      $formato = preg_replace( '/F/', $F, $formato ); // [F] mes con letras completo
      $formato = str_replace('tt', 'st', $formato);
  
          if(@$_COOKIE['language'] == "en_US"){
              $formato = str_replace("Lunes", "Monday", $formato) ;
              $formato = str_replace("Martes", "Tuesday", $formato) ;
              $formato = str_replace("Miercoles", "Wednesday", $formato) ;
              $formato = str_replace("Miércoles", "Wednesday", $formato) ;
              $formato = str_replace("Jueves", "Thursday", $formato) ;
              $formato = str_replace("Viernes", "Friday", $formato) ;
              $formato = str_replace("Sabado", "Saturday", $formato) ;
              $formato = str_replace("Sábado", "Saturday", $formato) ;
              $formato = str_replace("Domingo", "Sunday", $formato) ;
          }       
      
      return $formato;
    }


}

?>