<?php
//==============================
// FUNCIONES GENERALES DEL SITIO
//==============================

class funcion {
	
// Funci�n para limpiar los textos, as� evitamos posibles ataques por injection
	static function limpiar($texto){

		$texto_limpio = str_replace('\'','"',strip_tags(trim(urldecode($texto))));
		
		//Array con las posibles cabeceras a utilizar por un atacante
		$badHeads = array('Content-Type:',
		'MIME-Version:',
		'Content-Transfer-Encoding:',
		'Return-path:',
		'Subject:',
		'From:',
		'Envelope-to:',
		'To:',
		'bcc:',
		'cc:',
		'http',
		'www',
		'ftp',
		'.dat',
		'.txt',
		'.gif',
		'wget',
		'%20',
		'SELECT',
		'DROP'
		);
		
		//Comprobamos que entre los datos no se encuentre alguna de
		//las cadenas del array. Si se encuentra alguna cadena se
		//dirige a una p�gina de Forbidden
		foreach($badHeads as $valor){
		if(strpos(strtolower($texto_limpio), strtolower($valor)) !== false){
		header('HTTP/1.0 403 Forbidden');
		exit;
		}
		}
		
		return $texto_limpio;
	}


// Funci�n para cortar texto en general
	static function formatoRecorteGeneral($texto, $limite=100){   
    $texto = trim($texto);
    $texto = strip_tags($texto);
    $tamano = strlen($texto);
    $resultado = '';
    if($tamano <= $limite){
        return $texto;
    }else{
        $texto = substr($texto, 0, $limite);
        $palabras = explode(' ', $texto);
        $resultado = implode(' ', $palabras);
        $resultado .= '...';
    }   
    return $resultado;
	}

// Funci�n para cortar texto sin cortar palabras
	static function formatoRecorte($texto, $tamano, $puntos='...'){
	   $texto=strip_tags($texto);
	   if(strlen($texto)<=$tamano)return $texto;
	   $body = explode(' ', $texto);
	   $output = $body[0];
	   $i=1;
	   
	   while((strlen($output)+strlen($body[$i])+1)<=$tamano and $body[$i]){
		 $output .= " ".$body[$i];
		 $i++;
	   }
	   return $output.$puntos;
	}

	// Funci�n para Meta Description
	static function formatoDescription($texto,$tamano) { 
	
	$texto = strip_tags($texto);
	$texto=str_replace('<b>','',$texto);
	$texto=str_replace('</b>','',$texto);
	$texto=str_replace('�','',$texto);
	$texto=str_replace('�','',$texto);
	$texto=str_replace('<i>','',$texto);
	$texto=str_replace('&nbsp;','',$texto);
	$texto=str_replace('�','',$texto);
	$texto=str_replace('<br>',' ',$texto);
	
	$texto = preg_replace('/\s\s+/', ' ', $texto);

	if (strlen($texto) > $tamano) { 
		$texto = substr($texto, 0, $tamano); 
		$texto .= "..."; 
	}
	return $texto; 
	}

// Funci�n para mostrar precios
	static function formatoPrecio($prec){
		$prex=number_format($prec);
		$prex=str_replace(',','.',$prex);
		echo $prex;
	}

// Funci�n para mostrar decimales
	static function formatoDecimales($prec){
		$prec=str_replace('.',',',$prec);
		echo $prec;
	}

// Funci�n para limpiar la comilla simple
	static function LimpiaComillaSimple ($texto)
	{	
		$limpio = preg_replace("/'/", "&#39;", $texto);	
		return $limpio;
	}

// Funci�n para eliminar div de un texto
	static function eliminaDivs ($texto)
	{	
		$limpio = preg_replace("<div>", "", $texto);
		$limpio = preg_replace("</div>", "<br>", $limpio);	
		$limpio = preg_replace("<>", "", $limpio);
		return $limpio;
	}
		
// Funci�n para generar un nombre aleatorio
	static function Aleatorio($length=10,$uc=TRUE,$n=TRUE,$sc=FALSE)
	{
		$source = 'abcdefghijklmnopqrstuvwxyz';
		if($uc==1) $source .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		if($n==1) $source .= '1234567890';
		if($sc==1) $source .= '|@#~$%()=^*+[]{}-_';
		if($length>0){
			$rstr = "";
			$source = str_split($source,1);
			for($i=1; $i<=$length; $i++){
				mt_srand((double)microtime() * 1000000);
				$num = mt_rand(1,count($source));
				$rstr .= $source[$num-1];
			}
	
		}
		return $rstr;
	}

// Funci�n para mostrar dias entre fechas
	static function diasEntreFechas($fecha_inicial,$fecha_final){
		$dias	= (strtotime($fecha_inicial)-strtotime($fecha_final))/86400;
		$dias	= abs($dias);
		$dias	= floor($dias);
		if($dias<=0) {$dias=0;}		
		return $dias;
	}

// Funci�n para mostrar d�as restantes
	static function diasRestantes($fecha_final){
	    $fecha_actual	= date('Y-m-d');  
	    $dias			= strtotime($fecha_final)-strtotime($fecha_actual);  
	    $dias			= intval($dias/86400);
	    if($dias<=0) {$dias=0;}
	    return $dias; 
	}

// Funci�n para mostrar horas restantes
	static function horasRestantes($fecha_final){
	    $fecha_actual	= date('Y-m-d H:i:s'); 
	    $horas			= strtotime($fecha_final)-strtotime($fecha_actual);  
	    $horas			= intval($horas/3600);
	    if($horas<=0) {$horas=0;}
	    return $horas; 
	}

/*
// Funci�n encriptar
	static function encriptar($cadena, $llave=LLAVE_1){
// Utilizamos Cast-256 y ECB
		$identificador = mcrypt_module_open('cast-256', '', 'ecb', '');
// Determinamos el tama�o seg�n el tipo de identificador
		$tamano=mcrypt_enc_get_iv_size($identificador);
// Creamos el vector de inicio
		$inicio = mcrypt_create_iv($tamano, MCRYPT_RAND);
// Iniciamos los buffer
		mcrypt_generic_init($identificador, $llave, $inicio);
// Encriptamos
		$texto_encriptado = mcrypt_generic($identificador, $cadena);
// Vaciamos los buffer
		mcrypt_generic_deinit($identificador);
// Cerramos el m�dulo de encriptado
		mcrypt_module_close($identificador);
// Retornamos el resultado en Base 64 pero reemplazando los caracteres + y / para crear una ruta v�lida
		return str_replace(array('+', '/', '='), array('-', '_', '@'), base64_encode($texto_encriptado));
	}

// Funci�n desencriptar
	static function desencriptar($cadena, $llave=LLAVE_1){
// Leemos el resultado en Base 64 pero volviendo a mostrar los caracteres + y /
		$cadena = base64_decode(str_replace(array('-', '_', '@'), array('+', '/', '='), $cadena));
// Utilizamos Cast-256 y ECB
		$identificador = mcrypt_module_open('cast-256', '', 'ecb', '');
// Determinamos el tama�o seg�n el tipo de identificador
		$tamano=mcrypt_enc_get_iv_size($identificador);
// Creamos el vector de inicio
		$inicio = mcrypt_create_iv($tamano, MCRYPT_RAND);
// Iniciamos los buffer
		mcrypt_generic_init($identificador, $llave, $inicio);
// Desencriptamos
		$desencriptada = mdecrypt_generic($identificador, $cadena); 
// Vaciamos los buffer
		mcrypt_generic_deinit($identificador);
// Cerramos el m�dulo de desencriptado
		mcrypt_module_close($identificador);
// Retornamos la cadena desencriptada
		return $desencriptada;
	}
	
	*/
	 static function encriptar($data, $key=LLAVE_1){
        // Remove the base64 encoding from our key
        $encryption_key = base64_decode($key);
        // Generate an initialization vector
        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
        // Encrypt the data using AES 256 encryption in CBC mode using our encryption key and initialization vector.
        $encrypted = openssl_encrypt($data, 'aes-256-cbc', $encryption_key, 0, $iv);
        // The $iv is just as important as the key for decrypting, so save it with our encrypted data using a unique separator (::)
        return base64_encode($encrypted . '::' . $iv);
        
    }
    
    static function desencriptar($data, $key=LLAVE_1){
        // Remove the base64 encoding from our key
        $encryption_key = base64_decode($key);
        // To decrypt, split the encrypted data from our IV - our unique separator used was "::"
        list($encrypted_data, $iv) = explode('::', base64_decode($data), 2);
        return openssl_decrypt($encrypted_data, 'aes-256-cbc', $encryption_key, 0, $iv);
        
        
    }

// Calcula edad usando s�lo el a�o
	static function calculaEdad($anno_nacimiento){
		$ano_diferencia  = date("Y") - $anno_nacimiento;
		return $ano_diferencia;
	}

// Calcula edad usando fecha de nacimiento
	static function calcularEdad($fechanacimiento){
		list($ano,$mes,$dia) = explode("-",$fechanacimiento);
		$ano_diferencia  = date("Y") - $ano;
		$mes_diferencia = date("m") - $mes;
		$dia_diferencia   = date("d") - $dia;
		if ($dia_diferencia < 0 || $mes_diferencia < 0)
			$ano_diferencia--;
		return $ano_diferencia;
	}
			
// Funciones para limpiar y formatear el RUT
	static function limpiaRUT($rut_ingresado){      
		$rut_limpio = preg_replace("/[^k0-9]/i","",$rut_ingresado);
		$rut_limpio = str_replace(".,-","",$rut_limpio);
		$rut_limpio = strtoupper($rut_limpio);
		return $rut_limpio;
	}
	
	static function formateaRUT($rut_para_formatear){
		$rut_temporal = substr($rut_para_formatear,0,strlen($rut_para_formatear)-1);
		$digito_verificador =substr($rut_para_formatear,strlen($rut_para_formatear)-1,1);
		return number_format( $rut_temporal, 0, "", ".") . '-' .$digito_verificador;
	}

// Funci�n para pasar fecha de castellano a MYSQL
	static function cambiarfecha_mysql($fecha_castellano){
		list($dia,$mes,$ano)=explode('-',$fecha_castellano);
		$fecha_mysql="$ano-$mes-$dia";
		return $fecha_mysql;
	}

// Funci�n para mostrar el d�a
	static function nombre_dia($fecha_dia,$idioma=FALSE){ 
		$fechats = strtotime($fecha_dia);

			if(empty($idioma)) {
				switch (date('w', $fechats)){
					case 0: $nombre_dia='Domingo'; break;
					case 1: $nombre_dia='Lunes'; break;
					case 2: $nombre_dia='Martes'; break;
					case 3: $nombre_dia='Mi&eacute;rcoles'; break;
					case 4: $nombre_dia='Jueves'; break;
					case 5: $nombre_dia='Viernes'; break;
					case 6: $nombre_dia='S&aacute;bado'; break;
				}
			}

			if($idioma=='es') {
				switch (date('w', $fechats)){
					case 0: $nombre_dia='Domingo'; break;
					case 1: $nombre_dia='Lunes'; break;
					case 2: $nombre_dia='Martes'; break;
					case 3: $nombre_dia='Mi&eacute;rcoles'; break;
					case 4: $nombre_dia='Jueves'; break;
					case 5: $nombre_dia='Viernes'; break;
					case 6: $nombre_dia='S&aacute;bado'; break;
				}
			}

			if($idioma=='en') {
				switch (date('w', $fechats)){
					case 0: $nombre_dia='Sunday'; break;
					case 1: $nombre_dia='Monday'; break;
					case 2: $nombre_dia='Tuesday'; break;
					case 3: $nombre_dia='Wednesday'; break;
					case 4: $nombre_dia='Thursday'; break;
					case 5: $nombre_dia='Friday'; break;
					case 6: $nombre_dia='Saturday'; break;
				}
			}
			
			if($idioma=='po') {
				switch (date('w', $fechats)){
					case 0: $nombre_dia='Domingo'; break;
					case 1: $nombre_dia='Segunda-feira'; break;
					case 2: $nombre_dia='Ter�a-feira'; break;
					case 3: $nombre_dia='Quarta-feira'; break;
					case 4: $nombre_dia='Quinta-feira'; break;
					case 5: $nombre_dia='Sexta-feira'; break;
					case 6: $nombre_dia='S�bado'; break;
				}
			}

		return $nombre_dia;
	}

// Funci�n para mostrar sigla horaria
	static function siglaHoraria($hora){
	    $segmentos = explode(':', $hora);
	    if($segmentos[0]<12) {
	    	$sigla = 'AM';
	    } else {
	    	$sigla = 'PM';
	    }
	    return $sigla; 
	}

// FUNCION PARA CAMBIAR FECHA
	static function cambiar_fecha($fecha, $formato,$idioma=FALSE){ 
		$H='00'; $i='00'; $s='00'; $F=''; $M=''; $num_mes=0;
		
		if(empty($idioma)) {
			$Meses = array('','Enero','Febrero','Marzo','Abril','Mayo', 'Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
			$meses = array('','Ene','Feb','Mar','Abr','May','Jun','Jul' ,'Ago','Sep','Oct','Nov','Dic');
		}
		if($idioma=='es') {
			$Meses = array('','Enero','Febrero','Marzo','Abril','Mayo', 'Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
			$meses = array('','Ene','Feb','Mar','Abr','May','Jun','Jul' ,'Ago','Sep','Oct','Nov','Dic');
		}
		if($idioma=='en') {
			$Meses = array('','January','February','March','April','May', 'June','July','August','September','October','November','December');
			$meses = array('','Jan','Feb','Mar','Apr','May','Jun','Jul' ,'Aug','Sep','Oct','Nov','Dic');
		}

		//Fecha recibida en ingles con hora
		if(preg_match( "/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})/", $fecha, $mifecha)){
		$num_mes=$mifecha[2]; settype($num_mes, "integer");
		$D=$mifecha[3]; $m=$mifecha[2]; $F=$Meses[$num_mes]; $M=$meses[$num_mes]; $Y=$mifecha[1]; 
		$H=$mifecha[4]; $i=$mifecha[5]; $s=$mifecha[6];
		}
		//Fecha recibida en espa�ol con hora
		elseif(preg_match( "/([0-9]{1,2})-([0-9]{1,2})-([0-9]{4}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})/", $fecha, $mifecha)){
		$num_mes=$mifecha[2]; settype($num_mes, 'integer');
		$D=$mifecha[1]; $m=$mifecha[2]; $F=$Meses[$num_mes]; $M=$meses[$num_mes]; $Y=$mifecha[3]; 
		$H=$mifecha[4]; $i=$mifecha[5]; $s=$mifecha[6];
		}
		//Fecha recibida en ingles sin hora
		elseif(preg_match( "/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})/", $fecha, $mifecha)){
		$num_mes=$mifecha[2]; settype($num_mes, 'integer');
		$D=$mifecha[3]; $m=$mifecha[2]; $F=$Meses[$num_mes]; $M=$meses[$num_mes]; $Y=$mifecha[1];
		}
		//Fecha recibida en espa�ol sin hora
		elseif(preg_match( "/([0-9]{1,2})-([0-9]{1,2})-([0-9]{4})/", $fecha, $mifecha)){
		$num_mes=$mifecha[2]; settype($num_mes, 'integer');
		$D=$mifecha[1]; $m=$mifecha[2]; $F=$Meses[$num_mes]; $M=$meses[$num_mes]; $Y=$mifecha[3];
		}
		
		// Variable [y] ultimas dos cifras del a�o
		$y = substr($Y, 2);
		
		$formato = preg_replace( '/D/', $D, $formato ); // [D] d�as
		$formato = preg_replace( '/m/', $m, $formato ); // [m] mes con numeros
		$formato = preg_replace( '/Y/', $Y, $formato ); // [Y] a�o de 4 cifras
		$formato = preg_replace( '/y/', $y, $formato ); // [y] a�o de 2 cifras
		$formato = preg_replace( '/H/', $H, $formato ); // [H] hora de 0 a 23
		$formato = preg_replace( '/i/', $i, $formato ); // [i] minutos de 0 a 59
		$formato = preg_replace( '/s/', $s, $formato ); // [s] segundos de 0 a 59
		// Tienen que ir al final porque llevan texto para no ser reemplazado
		$formato = preg_replace( '/M/', $M, $formato ); // [M] mes con 3 letras
		$formato = preg_replace( '/F/', $F, $formato ); // [F] mes con letras completo
		
		return $formato;
	}

// Limpiar texto para Slug
    static function slug($cadena, $separador = '-'){
        //sin espacios al inicio o al final
        $cadena = trim($cadena);
		//utf8
        $cadena = utf8_decode($cadena);
        //limpiamos caracteres los latinos
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','�','�','�','�','Aacute','aacute'),"a",$cadena);
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','Eacute','eacute'),"e",$cadena);
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','Iacute','iacute'),"i",$cadena);
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','�','�','�','�','Oacute','oacute'),"o",$cadena);
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','Uacute','uacute'),"u",$cadena);
        //la �
        $cadena = str_replace(array('�','�','Ntilde','ntilde'),"n",$cadena);
        //caracteres extra�os
        $cadena = str_replace(array('�','�'),"c",$cadena);
        $cadena = str_replace('�',"y",$cadena);
        //pasamos a min�scula la cadena
        $cadena = strtolower($cadena);
        //limpiamos saltos de l�neas y tab
        $cadena = preg_replace("|[ \t\n\r]+|", " ", $cadena);
        //limpiamos todos los caracteres inv�lidos
        $cadena = preg_replace("|[^ A-Za-z0-9_]|", "", $cadena);
        $cadena = str_replace('39','',$cadena);
        //limpieza de espacios vac�os de los valores inv�lidos al final de la cadena
        $cadena = trim($cadena);
        //reemplazamos los espacios vacios por el separador
        $cadena = str_replace(" ", $separador, $cadena);
        return $cadena;
    }

// Limpiar texto para Tags
	static function tag($name,$utf=true){
		$sname = trim($name); //remover espacios vacios
		$sname = strtolower(preg_replace('/\s+/',' ',$sname)); // pasamos todo a minusculas
		if($utf){ // se el texto no viene en formato utf8 se le manda a codificar como tal.
		$sname = utf8_decode($sname);
		}
		// Lista de caracteres latinos y sus correspondientes para tags
		$table = array(
		'�'=>'S', '�'=>'s', '�'=>'Z', '�'=>'z', 'C'=>'C', 'c'=>'c', 'C'=>'C', 'c'=>'c',
		'�'=>'A', '�'=>'A', '�'=>'A', '�'=>'A', '�'=>'A', '�'=>'A', '�'=>'A', '�'=>'C', '�'=>'E', '�'=>'E',
		'�'=>'E', '�'=>'E', '�'=>'I', '�'=>'I', '�'=>'I', '�'=>'I', '�'=>'�', '�'=>'O', '�'=>'O', '�'=>'O',
		'�'=>'O', '�'=>'O', '�'=>'O', '�'=>'U', '�'=>'U', '�'=>'U', '�'=>'U', '�'=>'Y', '�'=>'B', '�'=>'S',
		'�'=>'a', '�'=>'a', '�'=>'a', '�'=>'a', '�'=>'a', '�'=>'a', '�'=>'a', '�'=>'c', '�'=>'e', '�'=>'e',
		'�'=>'e', '�'=>'e', '�'=>'i', '�'=>'i', '�'=>'i', '�'=>'i', '�'=>'o', '�'=>'o', '�'=>'o',
		'�'=>'o', '�'=>'o', '�'=>'o', '�'=>'o', '�'=>'u', '�'=>'u', '�'=>'u', '�'=>'y', '�'=>'y', '�'=>'b',
		'�'=>'y', 'R'=>'R', 'r'=>'r', ','=>''
		);
		$sname = strtr($sname, $table); // remplazamos los acentos, etc, por su correspondientes
		$sname = preg_replace('/[^a-zA-Z�0-9\/_|+ -]/','', $sname);
		return utf8_encode($sname);
	}
	
// Limpiar texto para EXCEL
    static function paraExcel($cadena){
        $cadena = trim($cadena);
        $cadena = utf8_decode($cadena);
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','�','�','�','�','Aacute','aacute'),"a",$cadena);
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','Eacute','eacute'),"e",$cadena);
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','Iacute','iacute'),"i",$cadena);
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','�','�','�','�','Oacute','oacute'),"o",$cadena);
        $cadena = str_replace(array('�','�','�','�','�','�','�','�','Uacute','uacute'),"u",$cadena);
        $cadena = str_replace(array('�','�','Ntilde','ntilde'),"n",$cadena);
        $cadena = str_replace(array('�','�'),"c",$cadena);
        $cadena = str_replace('�',"y",$cadena);
        $cadena = strtoupper($cadena);
        $cadena = preg_replace("|[ \t\n\r]+|", " ", $cadena);
        $cadena = preg_replace("|[^ A-Za-z0-9_]|", "", $cadena);
        $cadena = str_replace('39','',$cadena);
        $cadena = trim($cadena);
        return $cadena;
    }

}
//==================================
// FIN FUNCIONES GENERALES DEL SITIO
//==================================
?>