<?php
include('../../../configuracion.php');

$contactos = $db->results('contactos','*',"id!='0'",'id ASC');

/** PHPExcel */
include '../../lib/PHPExcel.php';

/** PHPExcel_Writer_Excel2007 */
include '../../lib/PHPExcel/Writer/Excel2007.php';

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("Via Magica");
$objPHPExcel->getProperties()->setLastModifiedBy("Via Magica");
$objPHPExcel->getProperties()->setTitle("Excel");
$objPHPExcel->getProperties()->setSubject("Excel");
$objPHPExcel->getProperties()->setDescription("Excel.");

// Nombre de las columnas
$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Fecha');
$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Nombre');
$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Email');
$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Teléfono');
$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Tipo');
$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Reserva');
$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Notas');
$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Estado');

// Estilo para los titulos de las columnas
$title = array(
    'borders' => array(
        'bottom' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array(
                'rgb' => '000000'
            )
        ),
        'right' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array(
                'rgb' => '000000'
            )
        ),
        'top' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array(
                'rgb' => '000000'
            )
        ),
        'left' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array(
                'rgb' => '000000'
            )
        )
    ),
    'fill' => array(
        'type' => PHPExcel_Style_Fill::FILL_SOLID,
        'startcolor' => array(
            'rgb' => 'E4EAF4',
        ),
    ),
);

// aplica el estilo desde A1 hasta J1
$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->applyFromArray($title);

$i=1;
foreach($contactos as $contacto){

$fecha = funcion::nombre_dia($contacto->fecha).', '.funcion::cambiar_fecha($contacto->fecha, 'D de F Y').' a las '.funcion::cambiar_fecha($contacto->fecha, 'H:i');
//$mensaje =  nl2br($contacto->mensaje);

    $estado= "INCIAL";
    if($contacto->estado==0){
        $estado = "INCIAL";
    }
     if($contacto->estado==2){
        $estado = "RESERVADO";
    }
     if($contacto->estado==2){
        $estado = "FINALIZADO";
    }
     if($contacto->estado==9){
        $estado = "CANCELADO";
    }



	$i++;
	$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, $fecha);
	$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, $contacto->nombre_completo);
	$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, $contacto->email);
	$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, $contacto->telefono);
    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, $contacto->tipo);
    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, $contacto->reserva);
	$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, $contacto->observaciones);
    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, $estado);
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Contactos');

	
// Save Excel 2007 file
$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);

//$objWriter->save(str_replace('.php', '.xlsx', __FILE__));


// Para que se baje y no se guarde en el servidor
header('Content-type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="contactos_'.date("Y-m-d_H-i").'.xlsx"');

// Write file to the browser
$objWriter->save('php://output');