<?php 
include("configuracion.php");
$light_mode = false;
$small_footer = true;
?>
<!doctype html>
<html lang="en">

  <head>
      <?php 
      // global head tag stylesheet
      /* **************************************** */
      include_once("components/head.php");
      /* **************************************** */
      // global head tag stylesheet
      ?>   
      <!-- CUSTOM CSS VIEW -->
      <!-- CUSTOM CSS VIEW END -->
  </head>

  <body class="body d-flex flex-column h-100">

    <?php 
      // global header menu 
      /* **************************************** */
      require_once("components/header.php");
      /* **************************************** */
      // global header end
    ?> 

    <main role="main " class="main">

    <section class="bg-body-tertiary">
        <div class="container p-0">
              <nav aria-label="breadcrumb">
                  <ol class="breadcrumb p-3  rounded-3">
                    <li class="breadcrumb-item">
                      <a class="link-body-emphasis" href="./">
                        <i class="bi bi-house"></i>
                        <span class="visually-hidden">Home</span>
                      </a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                      Contacto
                    </li>
                  </ol>
                </nav>
              </div>
    </section>


    <section class="my-lg-5 my-5">
            <!-- container -->
            <div class="container">
               <div class="row">
                  <!-- col -->
                  <div class="offset-lg-2 col-lg-8 col-12">
                     <div class="mb-8">
                        <!-- heading -->
                        <h1 class="h3">Consultas</h1>
                        <p class="lead mb-3">Llena el siguiente formulario para ponerte en contacto con nuestros ejecutivos.</p>


                        <?php if(isset($_GET["nombre"])){?>
                           <div class="alert alert-success" role="alert">
  Estimado(a) <?=$_GET["nombre"]?>, hemos recibido con éxito tu consulta, nuestros ejecutivos responderan a ella a la brevedad.
</div>
                           <?php }?>
                     </div>
                     <!-- form -->
                     <form class="row needs-validation" novalidate="" action="<?=WEB?>contacto-envio.php" method="POST">
                        <!-- input -->
                        <div class="col-md-6 mb-3">
                           <label class="form-label" for="contactFName">
                              Nombre
                              <span class="text-danger">*</span>
                           </label>
                           <input type="text" name="nombre" id="contactFName" class="form-control" name="contactFName" placeholder="" required="">
                           <div class="invalid-feedback">Por favor ingrese su Nombre.</div>
                        </div>
                        <div class="col-md-6 mb-3">
                           <!-- input -->
                           <label class="form-label" for="contactLName">
                              Apellido
                              <span class="text-danger">*</span>
                           </label>
                           <input type="text" name="apellido" id="contactLName" class="form-control" name="contactLName" placeholder="" required="">
                           <div class="invalid-feedback">Por favor ingrese su apellido.</div>
                        </div>
                        
                        <div class="col-md-12 mb-3">
                           <!-- input -->
                           <label class="form-label" for="contactTitle">Asuto</label>
                           <input type="text" name="motivo" id="contactTitle" name="contactTitle" class="form-control" placeholder="" required="">
                           <div class="invalid-feedback">Por favor ingrese asunto</div>
                        </div>
                        <div class="col-md-6 mb-3">
                           <label class="form-label" for="contactEmail">
                              Email
                              <span class="text-danger">*</span>
                           </label>
                           <input type="email" name="email" id="contactEmail" name="contactEmail" class="form-control" placeholder="" required="">
                           <div class="invalid-feedback">Por favor ingrese su correo</div>
                        </div>
                        <div class="col-md-6 mb-3">
                           <!-- input -->
                           <label class="form-label" for="contactPhone">Celular</label>
                           <input type="text" name="telefono" id="contactPhone" name="contactPhone" class="form-control" placeholder="" required="">
                           <div class="invalid-feedback">Por favor ingrese su celular</div>
                        </div>
                        <div class="col-md-12 mb-3">
                           <!-- input -->
                           <label class="form-label" for="contactTearea">Consulta/Mensaje</label>
                           <textarea rows="3" name="mensaje" id="contactTearea" class="form-control" placeholder="" required=""></textarea>
                           <div class="invalid-feedback">Por favor ingrese su consulta o mensaje</div>
                        </div>
                        <div class="col-md-12">
                           <!-- btn -->
                           <button type="submit" class="btn btn-primary">Enviar</button>
                        </div>
                     </form>
                  </div>
               </div>
            </div>
         </section>
           
 
    </main>


  
    
    
    <?php 
      /* **************************************** */
      // footer
      require_once("components/footer.php");
      // footer end
      // script js global
      require_once('components/bottom.php');
      //  script js global end
      /* **************************************** */
    ?> 
    
    <!-- CUSTOM VIEW SCRIPT/LIBRARY -->
    <!-- CUSTOM VIEW SCRIPT/LIBRARY END -->
  </body>
</html>