<?php

include('phpqrcode/qrlib.php');

final class BarcodeQR {
	/**
	 * Chart API URL
	 */
	//const API_CHART_URL = "http://chart.googleapis.com/chart";

	/**
	 * Code data
	 *
	 * @var string $_data
	 */
	private $_data;


	/**
	 * Create code with GIF, JPG, etc.
	 *
	 * @param string $type
	 * @param string $size
	 * @param string $content
	 */
	public function content($type = null, $size = null, $content = null) {
		$this->_data = "CNTS:TYPE:{$type};LNG:{$size};BODY:{$content};;";
	}

	/**
	 * Generate QR code image
	 *
	 * @param int $size
	 * @param string $filename
	 * @return bool
	 */
	public function draw($size = 150, $filename = null) {
		$size_cal = 6;
		if ($size == 70) {
			$size_cal = 2;
		}
		if ($size == 80) {
			$size_cal = 3;
		}
		QRcode::png($this->_data, $filename, QR_ECLEVEL_L, $size_cal,1);

		return true;

		return false;
	}


	/**
	 * Text code
	 *
	 * @param string $text
	 */
	public function text($text = null) {
		$this->_data = $text;
	}

	/**
	 * URL code
	 *
	 * @param string $url
	 */
	public function url($url = null) {
		$this->_data = preg_match("#^https?\:\/\/#", $url) ? $url : "http://{$url}";
	}

}
?>