<?php

class video_plugin {

	function info($url) {

		// Handle Youtube.com
		if (strpos($url, "youtube.com")) {
			$url = parse_url($url);
			$vid = parse_str($url['query'], $output);
			$video_id = $output['v'];
			$video['video_type'] = 'youtube';
			$video['video_id'] = $video_id;

			$url = 'https://gdata.youtube.com/feeds/api/videos?q='.$video_id.'&alt=json';

			if (function_exists('curl_init')) {
				$ch = curl_init();
				curl_setopt($ch,CURLOPT_URL,$url);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
				curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,10);
				$response = curl_exec($ch);
				curl_close($ch);
			} else {
				$response = file_get_contents($url);
			}

			$data = json_decode($response,true);

			$video['status'] = $data['feed']['openSearch$totalResults']['$t'];

			if ($video['status']>0) {

				// Data Array
				$video['published'] = $data['feed']['entry'][0]['published']['$t']; // Published date
				$video['updated'] = $data['feed']['entry'][0]['updated']['$t']; // Last updated
				$video['title'] = $data['feed']['entry'][0]['title']['$t']; // Title
				$video['info'] = $data['feed']['entry'][0]['content']['$t']; // Description
				$video['user'] = $data['feed']['entry'][0]['author'][0]['name']['$t']; // Author name
				$video['user_url'] = $data['feed']['entry'][0]['author'][0]['uri']['$t']; // Author link
				$video['comments'] = $data['feed']['entry'][0]['gd$comments']['gd$feedLink']['countHint']; // Comments
				$video['category'] = $data['feed']['entry'][0]['media$group']['media$category'][0]['$t']; // Category
				$video['duration'] = $data['feed']['entry'][0]['media$group']['yt$duration']['seconds']; // Duration
				$video['category'] = $data['feed']['entry'][0]['media$group']['media$description']['$t']; // Category
				$video['tags'] = $data['feed']['entry'][0]['media$group']['media$keywords']['$t']; // Tags
				$video['thumb_1'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][0]['url']; // 2 thumb
				$video['thumb_2'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][1]['url']; // 1 thumb
				$video['thumb_3'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][2]['url']; // 3 thumb
				$video['thumb_4'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][3]['url']; // 4 thumb

				$video['thumb_1_width'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][0]['width']; // 1 thumb width
				$video['thumb_2_width'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][1]['width']; // 2 thumb width
				$video['thumb_3_width'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][2]['width']; // 3 thumb width
				$video['thumb_4_width'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][3]['width']; // 4 thumb width

				$video['favorites'] = $data['feed']['entry'][0]['yt$statistics']['favoriteCount']; // favorite count
				$video['views'] = $data['feed']['entry'][0]['yt$statistics']['viewCount']; // views

				// Determin large thumbnail
				if ($video['thumb_1_width']=='320') {
					$video['thumb_large'] = $video['thumb_1'];
					$video['thumb_1'] = $video['thumb_2'];
					$video['thumb_2'] = $video['thumb_3'];
					$video['thumb_3'] = $video['thumb_4'];
				} else if ($video['thumb_2_width']=='320') {
					$video['thumb_large'] = $video['thumb_2'];
					$video['thumb_1'] = $video['thumb_1'];
					$video['thumb_2'] = $video['thumb_3'];
					$video['thumb_3'] = $video['thumb_4'];
				} else if ($video['thumb_3_width']=='320') {
					$video['thumb_large'] = $video['thumb_3'];
					$video['thumb_1'] = $video['thumb_2'];
					$video['thumb_2'] = $video['thumb_1'];
					$video['thumb_3'] = $video['thumb_4'];
				} else  {
					$video['thumb_large'] = $video['thumb_4'];
					$video['thumb_1'] = $video['thumb_2'];
					$video['thumb_2'] = $video['thumb_3'];
					$video['thumb_3'] = $video['thumb_1'];
				}

				$video['status'] = 'success';

			} else {
				$video['status'] = 'error';
			}

		} // end YouTube.com


		// Handle Youtu.be
		if (strpos($url, "youtu.be")) {
			$video_id=explode('youtu.be/', $url);
			$video_id=$video_id[1];
			$video['video_type'] = 'youtube';
			$video['video_id'] = $video_id;

			$url = 'https://gdata.youtube.com/feeds/api/videos?q='.$video_id.'&alt=json';

			if (function_exists('curl_init')) {
				$ch = curl_init();
				curl_setopt($ch,CURLOPT_URL,$url);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
				curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,10);
				$response = curl_exec($ch);
				curl_close($ch);
			} else {
				$response = file_get_contents($url);
			}

			$data = json_decode($response,true);

			$video['status'] = $data['feed']['openSearch$totalResults']['$t'];

			$data = json_decode($response,true);
			
			if ($video['status']>0) {

				// Data Array
				$video['published'] = $data['feed']['entry'][0]['published']['$t']; // Published date
				$video['updated'] = $data['feed']['entry'][0]['updated']['$t']; // Last updated
				$video['title'] = $data['feed']['entry'][0]['title']['$t']; // Title
				$video['info'] = $data['feed']['entry'][0]['content']['$t']; // Description
				$video['user'] = $data['feed']['entry'][0]['author'][0]['name']['$t']; // Author name
				$video['user_url'] = $data['feed']['entry'][0]['author'][0]['uri']['$t']; // Author link
				$video['comments'] = $data['feed']['entry'][0]['gd$comments']['gd$feedLink']['countHint']; // Comments
				$video['category'] = $data['feed']['entry'][0]['media$group']['media$category'][0]['$t']; // Category
				$video['duration'] = $data['feed']['entry'][0]['media$group']['yt$duration']['seconds']; // Duration
				$video['category'] = $data['feed']['entry'][0]['media$group']['media$description']['$t']; // Category
				$video['tags'] = $data['feed']['entry'][0]['media$group']['media$keywords']['$t']; // Tags
				$video['thumb_1'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][0]['url']; // 2 thumb
				$video['thumb_2'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][1]['url']; // 1 thumb
				$video['thumb_3'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][2]['url']; // 3 thumb
				$video['thumb_4'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][3]['url']; // 4 thumb

				$video['thumb_1_width'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][0]['width']; // 1 thumb width
				$video['thumb_2_width'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][1]['width']; // 2 thumb width
				$video['thumb_3_width'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][2]['width']; // 3 thumb width
				$video['thumb_4_width'] = $data['feed']['entry'][0]['media$group']['media$thumbnail'][3]['width']; // 4 thumb width

				$video['favorites'] = $data['feed']['entry'][0]['yt$statistics']['favoriteCount']; // favorite count
				$video['views'] = $data['feed']['entry'][0]['yt$statistics']['viewCount']; // views

				// Determin large thumbnail
				if ($video['thumb_1_width']=='320') {
					$video['thumb_large'] = $video['thumb_1'];
					$video['thumb_1'] = $video['thumb_2'];
					$video['thumb_2'] = $video['thumb_3'];
					$video['thumb_3'] = $video['thumb_4'];
				} else if ($video['thumb_2_width']=='320') {
					$video['thumb_large'] = $video['thumb_2'];
					$video['thumb_1'] = $video['thumb_1'];
					$video['thumb_2'] = $video['thumb_3'];
					$video['thumb_3'] = $video['thumb_4'];
				} else if ($video['thumb_3_width']=='320') {
					$video['thumb_large'] = $video['thumb_3'];
					$video['thumb_1'] = $video['thumb_2'];
					$video['thumb_2'] = $video['thumb_1'];
					$video['thumb_3'] = $video['thumb_4'];
				} else  {
					$video['thumb_large'] = $video['thumb_4'];
					$video['thumb_1'] = $video['thumb_2'];
					$video['thumb_2'] = $video['thumb_3'];
					$video['thumb_3'] = $video['thumb_1'];
				}

				$video['status'] = 'success';

			} else {
				$video['status'] = 'error';
			}

		} // end Youtu.be
				
		// Handle Vimeo
		if (strpos($url, "vimeo.com")) {
			$video_id=explode('vimeo.com/', $url);
			$video_id=$video_id[1];
			$video['video_type'] = 'vimeo';
			$video['video_id'] = $video_id;

			$url = 'https://vimeo.com/api/v2/video/'.$video_id.'.json';

			if (function_exists('curl_init')) {
				$ch = curl_init();
				curl_setopt($ch,CURLOPT_URL,$url);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
				curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,10);
				$response = curl_exec($ch);
				curl_close($ch);
			} else {
				$response = file_get_contents($url);
			}

			$data = json_decode($response,true);

			// Data Array
			if ($data!='') {

				$video['status'] = 'success';
				$video['title'] = $data[0]['title'];
				$video['info'] = $data[0]['description'];
				$video['mobile_url'] = $data[0]['mobile_url'];

				$video['thumb_small'] = $data[0]['thumbnail_small'];
				$video['thumb_med'] = $data[0]['thumbnail_medium'];
				$video['thumb_large'] = $data[0]['thumbnail_large'];

				$video['user'] = $data[0]['user_name'];
				$video['user_url'] = $data[0]['user_url'];
				$video['user_thumb_small'] = $data[0]['user_portrait_small'];
				$video['user_thumb_med'] = $data[0]['user_portrait_medium'];
				$video['user_thumb_large'] = $data[0]['user_portrait_large'];
				$video['user_thumb_huge'] = $data[0]['user_portrait_huge'];

				$video['likes'] = $data[0]['stats_number_of_likes'];
				$video['plays'] = $data[0]['stats_number_of_plays'];
				$video['comments'] = $data[0]['stats_number_of_comments'];

				$video['duration'] = $data[0]['duration'];
				$video['width'] = $data[0]['width'];
				$video['height'] = $data[0]['height'];
				$video['tags'] = $data[0]['tags'];

			} else {
				$video['status'] = 'error';
			}

		} // End Vimeo

		return $video;

	}


	function embed($url,$width='640',$height='390',$hd='hd',$autoplay=false) {

		$width=str_replace('px', '', $width);
		$height=str_replace('px', '', $height);

		// Handle Youtube
		if (strpos($url, "youtube.com")) {
			$url = parse_url($url);
			$vid = parse_str($url['query'], $output);
			$video_id = $output['v'];

			if ($autoplay=='autoplay') {$autoplay = '&amp;autoplay=1';} else {$autoplay = '';}
			if ($hd=='hd') {$quality = '?hd=1';} else {$quality = '?hd=0';}

			return '<iframe title="YouTube video player" class="youtube-player" type="text/html" width="'
			.$width.'" height="'.$height.'" src="https://www.youtube.com/embed/'.$video_id.$quality.$autoplay
			.'" frameborder="0" allowFullScreen></iframe>';	

		} // end YouTube


		// Handle Youtu.be
		else if (strpos($url, "youtu.be")) {
			$video_id=explode('youtu.be/', $url);
			$video_id=$video_id[1];

			if ($autoplay=='autoplay') {$autoplay = '&amp;autoplay=1';} else {$autoplay = '';}
			if ($hd=='hd') {$quality = '?hd=1';} else {$quality = '?hd=0';}

			return '<iframe title="YouTube video player" class="youtube-player" type="text/html" width="'
			.$width.'" height="'.$height.'" src="https://www.youtube.com/embed/'.$video_id.$quality.$autoplay
			.'" frameborder="0" allowFullScreen></iframe>';	

		} // end YouTube
		
				
		// Handle Vimeo
		else if (strpos($url, "vimeo.com")) {
			$video_id=explode('vimeo.com/', $url);
			$video_id=$video_id[1];

			if ($autoplay=='true' || $autoplay==true) {$autoplay = '&amp;autoplay=1';} else {$autoplay = '';}
			if ($hd=='yes') {$quality = '&amp;hd=1';} else {$quality = '';}

			return '<iframe src="https://player.vimeo.com/video/'
			.$video_id.'?title=0&amp;byline=0&amp;portrait=0'
			.$autoplay.'" width="'.$width.'" height="'.$height.'" frameborder="0"></iframe>';

		} // End Vimeo

		else {
			return 'Error! Invalid video url';
		}

	}
}

$video = new video_plugin;